/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.io.Connector;
import javax.microedition.io.HttpConnection;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Item;
import javax.microedition.lcdui.StringItem;
import javax.microedition.lcdui.TextField;
import javax.microedition.location.Criteria;
import javax.microedition.location.Location;
import javax.microedition.location.LocationListener;
import javax.microedition.location.LocationProvider;
import javax.microedition.location.QualifiedCoordinates;
import javax.microedition.midlet.MIDlet;
import javax.microedition.rms.RecordStore;

public class GpsClient
extends MIDlet
implements Runnable,
CommandListener,
LocationListener {
    public static final int GPS_UPDATE = 0;
    public static final int GPS_NO_UPDATE = 1;
    public static final int GPS_ERROR = 2;
    public static final double GPS_NULL = 200.0;
    Thread thr;
    Display _display = Display.getDisplay((MIDlet)this);
    Form _form = new Form("Konfiguration");
    TextField _user;
    TextField _pass;
    TextField _server;
    TextField _delay;
    Command _start;
    Command _exit;
    Command _hide;
    String login;
    double lat = 200.0;
    double lng = 200.0;
    double alt = 200.0;
    double lat_alt = 200.0;
    double lng_alt = 200.0;
    int status;
    int num = 1;
    LocationProvider lp;
    private StringItem _latitude;
    private StringItem _longitude;
    private StringItem _altitude;
    private StringItem _status;
    private StringItem _msg;
    private StringItem _error;
    private static final byte[] ALPHABET = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};

    public static String encode(String string) {
        byte[] byArray = string.getBytes();
        int n = byArray.length;
        int n2 = (n + 2) / 3 * 4;
        byte[] byArray2 = new byte[n2];
        int n3 = 0;
        for (int i = 0; i < n2; i += 4) {
            GpsClient.encodeQuorum(byArray, n3, n - n3, byArray2, i);
            n3 += 3;
        }
        return new String(byArray2);
    }

    private static void encodeQuorum(byte[] byArray, int n, int n2, byte[] byArray2, int n3) {
        byte by = byArray[n];
        byte by2 = n2 > 1 ? byArray[n + 1] : (byte)0;
        byte by3 = n2 > 2 ? byArray[n + 2] : (byte)0;
        byArray2[n3++] = ALPHABET[by >>> 2];
        byArray2[n3++] = ALPHABET[by << 4 & 0x30 | by2 >>> 4];
        byArray2[n3++] = n2 > 1 ? ALPHABET[by2 << 2 & 0x3C | by3 >>> 6] : 61;
        byArray2[n3++] = n2 > 2 ? ALPHABET[by3 & 0x3F] : 61;
    }

    public void run() {
        Criteria criteria;
        this._form = new Form("GpsClient");
        this._latitude = new StringItem("Latitude", "");
        this._longitude = new StringItem("Longitude", "");
        this._altitude = new StringItem("Altitude", "");
        this._status = new StringItem("#/Status/Ausgabe", "");
        this._msg = new StringItem("Nachricht", "");
        this._error = new StringItem("Fehler", "");
        this._form.append((Item)this._latitude);
        this._form.append((Item)this._longitude);
        this._form.append((Item)this._altitude);
        this._form.append((Item)this._status);
        this._form.append((Item)this._msg);
        this._form.append((Item)this._error);
        this._hide = new Command("hide", 1, 0);
        this._form.addCommand(this._hide);
        this._form.addCommand(this._exit);
        this._form.setCommandListener((CommandListener)this);
        this._display.setCurrent((Displayable)this._form);
        try {
            criteria = new Criteria();
            criteria.setHorizontalAccuracy(10);
            criteria.setVerticalAccuracy(10);
            criteria.setAltitudeRequired(true);
            criteria.setSpeedAndCourseRequired(false);
            criteria.setPreferredPowerConsumption(2);
            this.lp = LocationProvider.getInstance((Criteria)criteria);
            if (null != this.lp) {
                this.lp.setLocationListener((LocationListener)this, 1, 1, 1);
            } else {
                this.status = 2;
                this._error.setText("LocationProvider is null");
            }
        }
        catch (Exception exception) {
            this.status = 2;
            this._error.setText(exception.toString());
        }
        while (true) {
            int n;
            Object object;
            this._error.setText("");
            if (200.0 == this.lat && 200.0 == this.lng && 200.0 == this.alt) {
                this.status = 2;
                this._error.setText("Location is not valid");
            } else if (this.lat_alt != this.lat || this.lng_alt != this.lng) {
                this.lat_alt = this.lat;
                this.lng_alt = this.lng;
                this.status = 0;
            } else {
                this.status = 1;
            }
            if (2 != this.status) {
                this._latitude.setText(Double.toString(this.lat));
                this._longitude.setText(Double.toString(this.lng));
                this._altitude.setText(Double.toString(this.alt));
            } else {
                this._latitude.setText("-");
                this._longitude.setText("-");
                this._altitude.setText("-");
            }
            try {
                String string;
                criteria = (HttpConnection)Connector.open((String)(this._server.getString() + "/gps/client_saveNewPosition.php?num=" + this.num + "&status=" + this.status + "&lat=" + this.lat + "&lng=" + this.lng + "&alt=" + this.alt + "&login=" + this.login));
                criteria.setRequestMethod("GET");
                criteria.setRequestProperty("User-Agent", System.getProperty("microedition.platform"));
                int n2 = criteria.getResponseCode();
                if (200 == n2) {
                    int n3;
                    object = criteria.openInputStream();
                    byte[] byArray = new byte[255];
                    for (n = 0; n < 255 && (n3 = ((InputStream)object).read(byArray, n, 255 - n)) >= 0; n += n3) {
                    }
                    ((InputStream)object).close();
                    string = new String(byArray, 0, n);
                } else {
                    string = criteria.getResponseMessage();
                }
                criteria.close();
                this._status.setText(Integer.toString(this.num) + "/" + Integer.toString(this.status) + "/" + string);
            }
            catch (Exception exception) {
                this._error.setText(exception.toString());
            }
            if (0 == this.num % 6) {
                try {
                    criteria = (HttpConnection)Connector.open((String)(this._server.getString() + "/gps/mobile_getMessage.php?login=" + this.login));
                    criteria.setRequestMethod("GET");
                    criteria.setRequestProperty("User-Agent", System.getProperty("microedition.platform"));
                    int n4 = criteria.getResponseCode();
                    if (200 == n4) {
                        int n5;
                        InputStream inputStream = criteria.openInputStream();
                        object = new byte[255];
                        for (n5 = 0; n5 < 255 && (n = inputStream.read((byte[])object, n5, 255 - n5)) >= 0; n5 += n) {
                        }
                        inputStream.close();
                        String string = new String((byte[])object, 0, n5);
                        this._msg.setText(string);
                    } else {
                        this._msg.setText(criteria.getResponseMessage());
                    }
                    criteria.close();
                }
                catch (Exception exception) {
                    this._error.setText(exception.toString());
                }
            }
            try {
                Thread.sleep(Integer.parseInt(this._delay.getString()) * 1000);
            }
            catch (Exception exception) {
                this._error.setText(exception.toString());
            }
            ++this.num;
        }
    }

    public void locationUpdated(LocationProvider locationProvider, Location location) {
        if (location.isValid()) {
            this._error.setText("");
            QualifiedCoordinates qualifiedCoordinates = location.getQualifiedCoordinates();
            this.lat = qualifiedCoordinates.getLatitude();
            this.lng = qualifiedCoordinates.getLongitude();
            this.alt = qualifiedCoordinates.getAltitude();
            this.alt -= 39.0;
            this._latitude.setText(Double.toString(this.lat));
            this._longitude.setText(Double.toString(this.lng));
            this._altitude.setText(Double.toString(this.alt));
        } else {
            this.alt = 200.0;
            this.lng = 200.0;
            this.lat = 200.0;
            this._error.setText("Location is not valid");
            this._latitude.setText("-");
            this._longitude.setText("-");
            this._altitude.setText("-");
        }
    }

    public GpsClient() {
        String string = "http://gps.gpsu.de";
        String string2 = "30";
        try {
            byte[] byArray;
            byte[] byArray2;
            RecordStore recordStore = RecordStore.openRecordStore((String)"gpsc", (boolean)true);
            if (recordStore.getNumRecords() < 2) {
                byArray2 = string.getBytes();
                recordStore.addRecord(byArray2, 0, byArray2.length);
                byArray = string2.getBytes();
                recordStore.addRecord(byArray, 0, byArray.length);
            }
            byArray2 = recordStore.getRecord(1);
            string = new String(byArray2, 0, byArray2.length);
            byArray = recordStore.getRecord(2);
            string2 = new String(byArray, 0, byArray.length);
            recordStore.closeRecordStore();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this._server = new TextField("Server:", string, 50, 4);
        this._user = new TextField("Benutzer:", "", 30, 0);
        this._pass = new TextField("Passwort:", "", 30, 65536);
        this._delay = new TextField("Intervall (Sek.):", string2, 3, 2);
        this._form.append((Item)this._server);
        this._form.append((Item)this._user);
        this._form.append((Item)this._pass);
        this._form.append((Item)this._delay);
        this._start = new Command("starten", 1, 1);
        this._exit = new Command("beenden", 7, 1);
        this._form.addCommand(this._start);
        this._form.addCommand(this._exit);
        this._form.setCommandListener((CommandListener)this);
        this._display.setCurrent((Displayable)this._form);
    }

    public void stop() {
        this.lp.setLocationListener(null, -1, -1, -1);
    }

    protected void startApp() {
    }

    protected void pauseApp() {
    }

    public void commandAction(Command command, Displayable displayable) {
        if (this._start == command) {
            this.login = GpsClient.encode(this._user.getString() + ":" + this._pass.getString());
            try {
                RecordStore recordStore = RecordStore.openRecordStore((String)"gpsc", (boolean)true);
                byte[] byArray = this._server.getString().getBytes();
                recordStore.setRecord(1, byArray, 0, byArray.length);
                byte[] byArray2 = this._delay.getString().getBytes();
                recordStore.setRecord(2, byArray2, 0, byArray2.length);
                recordStore.closeRecordStore();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.thr = new Thread(this);
            this.thr.start();
        } else if (this._exit == command) {
            this.destroyApp(false);
            this.notifyDestroyed();
        } else if (this._hide == command) {
            Display.getDisplay((MIDlet)this).setCurrent(null);
        }
    }

    protected void destroyApp(boolean bl) {
    }

    public void providerStateChanged(LocationProvider locationProvider, int n) {
    }
}

